---
title: Overview · Cloudflare Workers docs
description: "With Cloudflare Workers, you can expect to:"
lastUpdated: 2025-08-18T14:27:42.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/workers/
  md: https://developers.cloudflare.com/workers/index.md
---

A serverless platform for building, deploying, and scaling apps across [Cloudflare's global network](https://www.cloudflare.com/network/) with a single command — no infrastructure to manage, no complex configuration

With Cloudflare Workers, you can expect to:

* Deliver fast performance with high reliability anywhere in the world
* Build full-stack apps with your framework of choice, including [React](https://developers.cloudflare.com/workers/framework-guides/web-apps/react/), [Vue](https://developers.cloudflare.com/workers/framework-guides/web-apps/vue/), [Svelte](https://developers.cloudflare.com/workers/framework-guides/web-apps/svelte/), [Next](https://developers.cloudflare.com/workers/framework-guides/web-apps/nextjs/), [Astro](https://developers.cloudflare.com/workers/framework-guides/web-apps/astro/), [React Router](https://developers.cloudflare.com/workers/framework-guides/web-apps/react-router/), [and more](https://developers.cloudflare.com/workers/framework-guides/)
* Use your preferred language, including [JavaScript](https://developers.cloudflare.com/workers/languages/javascript/), [TypeScript](https://developers.cloudflare.com/workers/languages/typescript/), [Python](https://developers.cloudflare.com/workers/languages/python/), [Rust](https://developers.cloudflare.com/workers/languages/rust/), [and more](https://developers.cloudflare.com/workers/runtime-apis/webassembly/)
* Gain deep visibility and insight with built-in [observability](https://developers.cloudflare.com/workers/observability/logs/)
* Get started for free and grow with flexible [pricing](https://developers.cloudflare.com/workers/platform/pricing/), affordable at any scale

Get started with your first project:

[Deploy a template](https://dash.cloudflare.com/?to=/:account/workers-and-pages/templates)

[Deploy with Wrangler CLI](https://developers.cloudflare.com/workers/get-started/guide/)

***

## Build with Workers

#### Front-end applications

Deploy [static assets](https://developers.cloudflare.com/workers/static-assets/) to Cloudflare's [CDN & cache](https://developers.cloudflare.com/cache/) for fast rendering

#### Back-end applications

Build APIs and connect to data stores with [Smart Placement](https://developers.cloudflare.com/workers/configuration/smart-placement/) to optimize latency

#### Serverless AI inference

Run LLMs, generate images, and more with [Workers AI](https://developers.cloudflare.com/workers-ai/)

#### Background jobs

Schedule [cron jobs](https://developers.cloudflare.com/workers/configuration/cron-triggers/), run durable [Workflows](https://developers.cloudflare.com/workflows/), and integrate with [Queues](https://developers.cloudflare.com/queues/)

#### Observability & monitoring

Monitor performance, debug issues, and analyze traffic with [real-time logs](https://developers.cloudflare.com/workers/observability/logs/) and [analytics](https://developers.cloudflare.com/workers/observability/metrics-and-analytics/)

***

## Integrate with Workers

Connect to external services like databases, APIs, and storage via [Bindings](https://developers.cloudflare.com/workers/runtime-apis/bindings/), enabling functionality with just a few lines of code:

**Storage**

**[Durable Objects](https://developers.cloudflare.com/durable-objects/)**

Scalable stateful storage for real-time coordination.

**[D1](https://developers.cloudflare.com/d1/)**

Serverless SQL database built for fast, global queries.

**[KV](https://developers.cloudflare.com/kv/)**

Low-latency key-value storage for fast, edge-cached reads.

**[Queues](https://developers.cloudflare.com/queues/)**

Guaranteed delivery with no charges for egress bandwidth.

**[Hyperdrive](https://developers.cloudflare.com/hyperdrive/)**

Connect to your external database with accelerated queries, cached at the edge.

**Compute**

**[Workers AI](https://developers.cloudflare.com/workers-ai/)**

Machine learning models powered by serverless GPUs.

**[Workflows](https://developers.cloudflare.com/workflows/)**

Durable, long-running operations with automatic retries.

**[Vectorize](https://developers.cloudflare.com/vectorize/)**

Vector database for AI-powered semantic search.

**[R2](https://developers.cloudflare.com/r2/)**

Zero-egress object storage for cost-efficient data access.

**[Browser Rendering](https://developers.cloudflare.com/browser-rendering/)**

Programmatic serverless browser instances.

**Media**

**[Cache / CDN](https://developers.cloudflare.com/cache/)**

Global caching for high-performance, low-latency delivery.

**[Images](https://developers.cloudflare.com/images/)**

Streamlined image infrastructure from a single API.

***

Want to connect with the Workers community? [Join our Discord](https://discord.cloudflare.com)
