---
title: How we AI · Cloudflare Style Guide
description: This section shares how Cloudflare uses AI to accelerate and
  augment our content operations. We view AI as a tool that enables us to do our
  best work, faster. Whether we are designing prompts, researching a new
  product, or finding ways to turn a manual, week-long process into a job that
  takes an afternoon to complete, we are continuously looking for ways to
  iterate and streamline our operations. We know that when we can save time on
  one time-intensive task, we can spend more time on improving our content
  experiences for our customers.
lastUpdated: 2025-11-12T20:09:05.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/how-we-docs/how-we-ai/
  md: https://developers.cloudflare.com/style-guide/how-we-docs/how-we-ai/index.md
---

This section shares how Cloudflare uses AI to accelerate and augment our content operations. We view AI as a tool that enables us to do our best work, faster. Whether we are designing prompts, researching a new product, or finding ways to turn a manual, week-long process into a job that takes an afternoon to complete, we are continuously looking for ways to iterate and streamline our operations. We know that when we can save time on one time-intensive task, we can spend more time on improving our content experiences for our customers.

As a result, we use and have used AI to:

* Vibecode, test, and deploy a web application for scoring in-product strings, error messages, and API docs.
* Perform competitive analyses and audits on documentation.
* Streamline documenting REST API examples.
* Design prompts based on our content types, templates, and style to enable stakeholders with a doc idea to quickly draft content for us to review and publish.
* Find topics missing descriptions, generate descriptions based on the page’s content, and add them to each page.
* And more…

We hope you learn from the topics below. As always, [submit a pull request](https://developers.cloudflare.com/style-guide/contributions/) if you find something that is inaccurate, missing, or needs more information.

* [When we use AI](https://developers.cloudflare.com/style-guide/how-we-docs/how-we-ai/when-we-use-ai/)
* [Prompt templates](https://developers.cloudflare.com/style-guide/how-we-docs/how-we-ai/prompt-templates/)
* [Prompt libraries](https://developers.cloudflare.com/style-guide/how-we-docs/how-we-ai/prompt-libraries/)
* [Examples](https://developers.cloudflare.com/style-guide/how-we-docs/how-we-ai/examples/)
