---
title: Dashes · Cloudflare Style Guide
description: "Dashes look like hyphens, but are wider. An em dash is the widest
  type of dash. Dashes have a different purpose than hyphens. We use two types
  of dashes:"
lastUpdated: 2024-08-14T21:26:42.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/grammar/punctuation-marks-and-symbols/dashes/
  md: https://developers.cloudflare.com/style-guide/grammar/punctuation-marks-and-symbols/dashes/index.md
---

Dashes look like hyphens, but are wider. An em dash is the widest type of dash. Dashes have a different purpose than hyphens. We use two types of dashes:

## Hyphen (-)

**Hyphenate compound modifiers that are placed before the noun.** Compound modifiers that come before the noun require a hyphen to distinguish them from individual modifiers and nouns. Do not hyphenate compound modifiers that come after the noun. Hyphens are used in compound words and to express ranges.

Examples:

* The most up-to-date software can be found here.

* It takes 24-48 hours for the data to upload.

Note

Never include whitespaces around a hyphen.

Additional examples:

| ✅ | ❌ | Rationale |
| - | - | - |
| Protect your Internet property from common vulnerabilities with our enterprise-class Web Application Firewall (WAF). | Protect your Internet property from common vulnerabilities with our enterprise class Web Application Firewall (WAF). | ‘Enterprise-class’ refers to the ability of something to scale with and handle the needs of large enterprises. A hyphen is necessary because the compound modifier comes before the noun. |
| Our WAF is enterprise class. | Our WAF is enterprise-class. | ‘Enterprise class’ modifies ‘WAF.’ A hyphen is not necessary because the compound modifier comes after the noun. |

## Em dash (—)

**Use em dashes to break up thoughts within a single sentence.** Em dashes (—) or double dashes (--) with spaces around them may be used to break up thoughts within a sentence. Single dashes (-), or hyphens, are commonly used to write compound words/modifiers and should never be used to break up thoughts in this way.

* Shortcut for Mac users: Hold down Shift and Option keys, then press the Minus key

* Shortcut for PC users: Hold down the Alt key and type 0151

Dashes are used in pairs (in place of parenthesis) or alone (in place of a semicolon or colon).

Examples:

* Cookies provide saved information about a user’s session to establish a “state” — in most cases, identity — as your browser makes a request.

* Embed yourself in the team — the best results will come when trust is built.

Note

Following AP style guides, and to improve readability, we include whitespaces before and after the em dash.

Additional examples:

| ✅ | ❌ | Rationale |
| - | - | - |
| The app has made security and privacy core to the company’s mission — and that is why it chose Cloudflare to provide an extra layer of protection. | The app has made security and privacy core to the company’s mission—and that is why it chose Cloudflare to provide an extra layer of protection. | An em dash with spaces on both sides is the appropriate way to distinguish the offset phrase at the end of this sentence. |
| ACME has always looked deeply into two sources of traffic -- organic and direct traffic. | ACME has always looked deeply into two sources of traffic - organic and direct traffic. | A double dash is the appropriate way to clarify different types of traffic at the end of this sentence. A hyphen should not be used in place of a double dash. |

Additional dash information:

| Punctuation | Character/HTML Code | When to use in Cloudflare documentation | Justification |
| - | - | - | - |
| Hyphen | \&#45 | Negative numbers, compounding nouns, compound adjectives, removing ambiguity, certain prefixes, certain units | Use a hyphen instead of an en dash. |
| Minus | − | Do not use | |
| Em Dash | — | Empty table cells | Heavy use of the em dash creates choppy sentences that might annoy readers. |
| En Dash | – | Copyright year spans | To avoid possible confusion, the word "to" should be used instead of an en dash in a range of numbers because the en dash can be misinterpreted as a minus sign. |
