---
title: Choose an on-ramp · Cloudflare Learning Paths
description: Similar to the network onboarding practices in the Replace your VPN
  implementation guide, there are a number of ways to on-ramp your network
  traffic to the Cloudflare global network. This guide will quickly explore all
  of the options to on-ramp traffic to Cloudflare Gateway to inspect, apply
  policies, and filter.
lastUpdated: 2025-10-21T14:33:19.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/secure-internet-traffic/connect-devices-networks/choose-on-ramp/
  md: https://developers.cloudflare.com/learning-paths/secure-internet-traffic/connect-devices-networks/choose-on-ramp/index.md
---

Similar to the network onboarding practices in the [Replace your VPN](https://developers.cloudflare.com/learning-paths/replace-vpn/connect-private-network/) implementation guide, there are a number of ways to on-ramp your network traffic to the Cloudflare global network. This guide will quickly explore all of the options to on-ramp traffic to Cloudflare Gateway to inspect, apply policies, and filter.

Note

The following steps are identical to [Connect user devices](https://developers.cloudflare.com/learning-paths/replace-vpn/connect-devices/) in the Replace your VPN implementation guide. If you have already completed Replace your VPN, you can skip ahead to [Network on-ramps](#network-on-ramps).

## Device on-ramps

The most common way to protect and filter your end-user traffic is by using a device client. The standard Cloudflare device client supports a number of operating systems and deployment methodologies, but there can still be scenarios in which an alternative path makes sense.

### Zero Trust Client

Cloudflare WARP is the most common onramp to send user traffic to Gateway. It is a lightweight device client, which builds proxy tunnels using either Wireguard or MASQUE, and builds a DNS proxy using DNS-over-HTTPS. It supports all major operating systems, supports all common forms of endpoint management tooling, and has a robust series of management parameters and profiles to accurately scope the needs of a diverse user base. It has flexible operating modes and can control device traffic as a proxy, control device DNS traffic as a DNS proxy, or both. It is the most common method to send traffic from user devices to be filtered and decrypted by Cloudflare Gateway.

### PAC files (Enterprise only)

Cloudflare supports filtering HTTP/S traffic sent via a PAC file on a user device. PAC files configured to send traffic to Cloudflare target a domain specific to your account tenant, and receive and process all URL traffic for that device that fits the proxy profile. PAC files are most commonly used in scenarios in which the device client is not appropriate or cannot be installed -- specifically Windows pre-2008 and Windows Server 2012, and devices which cannot install client software at all.

### Clientless Browser Isolation

Cloudflare Browser Isolation runs a headless, Chromium-based browser for your users to accomplish their secure browsing needs. It can be activated via an Access application, a Gateway policy, or by using link-based isolation (reverse proxy). In this model, your users can connect from any device to a proxy website to browse the Internet while applying all your Gateway HTTP policies and inspection requirements.

| | WARP | PAC Files | Clientless Browser Isolation |
| - | - | - | - |
| Supported OS | macOS, Windows, Linux, iOS, Android | All desktop OS | All OS (with HTML5 compliant browser) |
| Configurable via MDM | Yes | Yes | N/A |
| Gateway policy types supported | DNS, Network, HTTP, Resolver, Egress | HTTP | DNS, Network, HTTP, Resolver, Egress |
| Identity-based policies supported | Yes | No | Yes |

## Network on-ramps

The primary ways to source multi-device or network traffic to Cloudflare Gateway are via Magic WAN using GRE or IPsec tunnels, the [WARP Connector](#warp-connector) as a software-defined all-ports traffic proxy, or via upstream DNS for a whole network using [DNS filtering locations](#dns-filtering-locations).

### Magic WAN

Note

Only available on Enterprise plans.

[Magic WAN](https://developers.cloudflare.com/magic-wan/) is Cloudflare's offering most analogous to a traditional SD-WAN. Magic WAN is typically deployed via an IPsec or GRE tunnel terminating on customer devices (such as firewalls or routers), or via our Magic WAN Connector hardware device. You can also be deploy Magic WAN using [Cloudflare Network Interconnect](https://developers.cloudflare.com/network-interconnect/) (CNI) at private peering locations or some public cloud instances (where compatible).

Magic WAN on-ramps traffic via your connections and can send all network and HTTP traffic through Cloudflare Gateway for inspection.

For more information on how Magic WAN integrates with Zero Trust, refer to [Zero Trust integration](https://developers.cloudflare.com/magic-wan/zero-trust/).

### WARP Connector Beta

[WARP Connector](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/warp-connector/), a software agent similar to our device client, functions as a virtual device to establish a connection between your network and the Cloudflare global network. You can install WARP Connector on a dedicated Linux server or virtual machine.

WARP Connector supports egressing traffic from your private network to the Internet as a gateway. This means it can allow traffic initiated from a network to be on-ramped to Cloudflare for either public or private destinations. You can use WARP Connector to establish a secure egress path for servers or users on a network which may not each be able to run the WARP client and still apply Gateway network and HTTP inspection policies. This connection is most analogous to proxy server connectivity or site-to-site VPN.

For more information on setting up Cloudflare Tunnel via WARP Connector, refer to [Set up WARP Connector](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/warp-connector/).

### DNS filtering locations

DNS locations are a collection of DNS endpoints which can be mapped to physical entities such as offices, homes, or data centers.

The fastest way to start filtering DNS queries from a location is by changing the DNS resolvers at the router or updating the upstream resolution to Cloudflare DNS resolution endpoints. This can also be accomplished from individual devices, or an network or subnet which sets resolver IPs for clients via DHCP.

For more information on setting up DNS locations, refer to [Add locations](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/agentless/dns/locations/).

| | Magic WAN | WARP Connector | DNS Locations |
| - | - | - | - |
| Gateway policy types supported | Network, HTTP, Egress | Network, HTTP, Egress | DNS, Resolver |
